package h.com.serialapp.adapter;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import h.com.serialapp.R;
import h.com.serialapp.util.ListViewHolder;
import h.com.serialportapi.comn.message.IMessage;
import h.com.serialportapi.comn.message.LogManager;

/**
 * Created by hxd on 2018/10/21.
 */

public class LogAdapter extends BaseAdapter {
    @Override
    public int getCount() {
        return LogManager.instance().messages.size();
    }

    @Override
    public IMessage getItem(int position) {
        return LogManager.instance().messages.get(position);
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(int position, android.view.View convertView, ViewGroup parent) {

        IMessage message = getItem(position);

        ListViewHolder holder;
        if (convertView == null) {
            holder = new ListViewHolder(R.layout.item_log, parent);
            convertView = holder.getItemView();
        } else {
            holder = (ListViewHolder) convertView.getTag();
        }

        TextView tvLog = holder.getText(R.id.tv_log);
        TextView tvNum = holder.getText(R.id.tv_num);

        tvLog.setText(message.getMessage());
        tvLog.setEnabled(message.isToSend());

        tvNum.setText(String.valueOf(position + 1));

        return convertView;
    }

    public void add(IMessage message) {
        LogManager.instance().add(message);
        notifyDataSetChanged();
//        updateList();
    }


}
